import unittest
from app import create_app


class TestAPI(unittest.TestCase):
    """API 测试类"""

    def setUp(self):
        """测试前设置"""
        self.app = create_app('testing')
        self.client = self.app.test_client()

    def test_hello_world(self):
        """测试 Hello World 端点"""
        response = self.client.get('/api/hello')
        data = response.get_json()

        self.assertEqual(response.status_code, 200)
        self.assertEqual(data['message'], 'Hello, World!')
        self.assertEqual(data['status'], 'success')

    def test_hello_name(self):
        """测试个性化问候端点"""
        response = self.client.get('/api/hello/Alice')
        data = response.get_json()

        self.assertEqual(response.status_code, 200)
        self.assertEqual(data['message'], 'Hello, Alice!')
        self.assertEqual(data['status'], 'success')


if __name__ == '__main__':
    unittest.main()
